% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_structural_shocks.R
\name{compute_structural_shocks}
\alias{compute_structural_shocks}
\title{Computes posterior draws of structural shocks}
\usage{
compute_structural_shocks(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of either of the classes: 
PosteriorBSVAR, PosteriorBSVARMSH, PosteriorBSVARMIX, or PosteriorBSVARSV
obtained by running the \code{estimate} function. The interpretation depends on the normalisation of the shocks
using function \code{normalise_posterior()}. Verify if the default settings are appropriate.}
}
\value{
An object of class PosteriorShocks, that is, an \code{NxTxS} array with attribute PosteriorShocks 
containing \code{S} draws of the structural shocks.
}
\description{
Each of the draws from the posterior estimation of a model is transformed into
a draw from the posterior distribution of the structural shocks.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 2)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in$get_last_draw(), 50)

# compute structural shocks
shocks         = compute_structural_shocks(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 10) |> 
  estimate(S = 50) |> 
  compute_structural_shocks() -> ss

}
\seealso{
\code{\link{estimate}}, \code{\link{normalise_posterior}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
