% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpretation.R
\name{edgeprob}
\alias{edgeprob}
\title{Create all predicted tie probabilities using MPLE}
\usage{
edgeprob(object, verbose = FALSE)
}
\arguments{
\item{object}{An \code{ergm}, \code{btergm}, or \code{mtergm} object.}

\item{verbose}{Print details?}
}
\value{
The first variable in the resulting data frame contains the edge
value (i.e., the dependent variable, which is usually binary). The next
variables contain all the predictors from the ERGM or TERGM (i.e., the change
statistics). The next five variables contain the indices of the sender (i),
the receiver (j), the time step (t), the vertex id of i (i.name), and the
vertex id of j (j.name). These five variables serve to identify the dyad. The
last variable contains the computed edge probabilities.
}
\description{
Create all predicted tie probabilities using MPLE.
}
\details{
For a given (T)ERGM, return a data frame with all predicted edge
probabilities along with the design matrix of the MPLE logit model, based
on the estimated coefficients and the design matrix, for all time points,
along with \code{i}, \code{j}, and \code{t} variables indicating where the
respective dyad is located.

\code{edgeprob} is a convenience function that creates a data frame with all
dyads in the ERGM or TERGM along with their edge probabilities and their
predictor values (i.e., change statistics). This is useful for creating
marginal effects plots or contrasting multiple groups of dyads. This function
works faster than the \code{\link{interpret}} function.
}
\seealso{
Other interpretation: 
\code{\link{interpret}()},
\code{\link{marginalplot}()}
}
\concept{interpretation}
