% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbergm.R
\docType{class}
\name{tbergm-class}
\alias{tbergm-class}
\alias{show,tbergm-method}
\alias{nobs,tbergm-method}
\alias{timesteps.tbergm}
\alias{summary,tbergm-method}
\title{An S4 class to represent a fitted TERGM using Bayesian estimation}
\usage{
\S4method{show}{tbergm}(object)

\S4method{nobs}{tbergm}(object)

timesteps.tbergm(object)

\S4method{summary}{tbergm}(object, ...)
}
\arguments{
\item{object}{A \code{tbergm} object.}

\item{...}{Further arguments for the \code{summary} function in the
\pkg{Bergm} package.}
}
\description{
An S4 class to represent a fitted TERGM using Bayesian estimation.
}
\details{
\code{tbergm} objects result from Bayesian estimation of a TERGM using the
\code{\link{tbergm}} function. They contain the original \code{bergm} object
and some additional information.
}
\section{Functions}{
\itemize{
\item \code{show,tbergm-method}: Show the coefficients of a \code{tbergm} object.

\item \code{nobs,tbergm-method}: Return the number of observations saved in a
\code{tbergm} object.

\item \code{timesteps.tbergm}: Return the number of time steps saved in a
\code{tbergm} object.

\item \code{summary,tbergm-method}: Summary of a fitted \code{tbergm} object.
}}

\section{Slots}{

\describe{
\item{\code{time.steps}}{Object of class \code{"numeric"}. Number of time steps.}

\item{\code{formula}}{Object of class \code{"formula"}. The original model formula
(without indices for the time steps).}

\item{\code{formula2}}{The revised formula with the object references after applying
the \code{\link{tergmprepare}} function.}

\item{\code{auto.adjust}}{Object of class \code{"logical"}. Indicates whether
automatic adjustment of dimensions was done before estimation.}

\item{\code{offset}}{Object of class \code{"logical"}. Indicates whether an offset
matrix with structural zeros was used.}

\item{\code{directed}}{Object of class \code{"logical"}. Are the dependent networks
directed?}

\item{\code{bipartite}}{Object of class \code{"logical"}. Are the dependent networks
bipartite?}

\item{\code{estimate}}{Estimate: \code{"bergm"} for Bayesian estimation.}

\item{\code{bergm}}{The original \code{bergm} object as estimated by the
\code{\link[Bergm]{bergm}} function in the \pkg{Bergm} package.}

\item{\code{nvertices}}{Number of vertices.}

\item{\code{data}}{The data after processing by the \code{\link{tergmprepare}}
function.}
}}

\seealso{
Other tergm-classes: 
\code{\link{btergm-class}},
\code{\link{createBtergm}()},
\code{\link{createMtergm}()},
\code{\link{createTbergm}()},
\code{\link{mtergm-class}}
}
\author{
Philip Leifeld
}
\concept{tergm-classes}
