% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_semicircle.R
\name{buffer_semicircle}
\alias{buffer_semicircle}
\title{A Semicircle Function}
\usage{
buffer_semicircle(point, radius, degree)
}
\arguments{
\item{point}{Centre point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{radius}{Radius of the buffer (numeric)}

\item{degree}{The angle at which the wedge is centred (clockwise). Must be between 0 and 360 (numeric)}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
Creates a semicircular polygon, wrapper around \code{buffer_wedge(point, radius, degree, degree_width = 45)}
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)

buffer_semicircle(example_point, 200, 90) -> semicircular_buffer
plot(semicircular_buffer)
}
\keyword{semicircle}
\keyword{wedge}
