% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildclmm}
\alias{buildclmm}
\title{Use \code{buildmer} to fit cumulative link mixed models using \code{clmm} from package \code{ordinal}}
\usage{
buildclmm(
  formula,
  data = NULL,
  cl = NULL,
  direction = c("order", "backward"),
  crit = "LRT",
  include = NULL,
  calc.summary = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula specifying both fixed and random effects using \code{lme4} syntax}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{...}{Additional options to be passed to \code{clmm}}
}
\description{
Use \code{buildmer} to fit cumulative link mixed models using \code{clmm} from package \code{ordinal}
}
\details{
\code{buildclmm} tries to guess which of \code{...} are intended for \code{clm} and which are for \code{clmm}. If this goes wrong, this behavior can be suppressed by passing explicit \code{clm.control} and \code{clmm.control} arguments. If one of these is specified, any \code{control} argument is interpreted to be intended for the other one; if both are specified in conjunction with a third \code{control} argument, an error is raised.
}
\examples{
if (requireNamespace('ordinal')) {
model <- buildclmm(SURENESS ~ PROD + (1|RESP),data=ordinal::soup,link='probit',
	threshold='equidistant')
}
}
\seealso{
\code{\link{buildmer-package}}
}
