% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_csv_files_from_dir.R
\name{read_csv_files_from_dir}
\alias{read_csv_files_from_dir}
\title{Reads all CSV files from a directory}
\usage{
read_csv_files_from_dir(dir_path = ".", col_types = NULL, .id = NULL)
}
\arguments{
\item{dir_path}{Path to the directory containing the CSV files.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows of the
input, interspersed throughout the file. This is convenient (and fast),
but not robust. If the guessed types are wrong, you'll need to increase
\code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[readr:cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set `options(readr.show_col_types = FALSE).}

\item{.id}{The name of a column in which to store the file path. This is
useful when reading multiple input files and there is data in the file
paths, such as the data collection date. If \code{NULL} (the default) no extra
column is created.}
}
\value{
A \link[tibble:tibble-package]{tibble}. If there is any column type mismatch during data frames row binding, an error will occur. This is because R cannot combine columns of different types. For example, you cannot combine a column of integers with a column of characters.
}
\description{
\code{read_csv_files_from_dir} reads all csv files from the \code{"~/data"} directory and returns an appended dataframe. The resulting dataframe will be in the same order as the CSV files in the directory.
}
\examples{

directory <- system.file("csvfolder",  package = "bulkreadr")

read_csv_files_from_dir(dir_path = directory, .id = "cut")

# Column types mismatch error --------------------------------------
# If the `read_csv_files_from_dir()` function complains about a data type mismatch,
# then set the `col_types` argument to `"c"`.
# This will make all the column types in the resulting dataframe be characters.


}
\seealso{
\code{\link[=read_excel_files_from_dir]{read_excel_files_from_dir()}} which reads Excel workbooks data from a directory.
}
