% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_gkTau}
\alias{pair_gkTau}
\title{Goodman Kruskal's Tau for association between ordinal factors.}
\usage{
pair_gkTau(d, handle.na = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{ignored. Pairwise complete observations are used automatically.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with Goodman Kruskal's Tau for every factor variable pair,
or NULL if there are not at least two factor variables
}
\description{
Calculates Goodman Kruskal's Tau coefficient for every factor variable pair in a dataset.
}
\details{
The Goodman Kruskal's Tau coefficient is calculated using \code{\link[DescTools]{GoodmanKruskalTau}}
function from the \code{DescTools} package. Assumes factor levels are in the given order.
NAs are automatically handled by pairwise omit.
}
\examples{
 pair_gkTau(iris)
}
