% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bunchit.R
\name{bunchit}
\alias{bunchit}
\title{Bunching Estimator}
\usage{
bunchit(z_vector, binv = "median", zstar, binwidth, bins_l, bins_r,
  poly = 9, bins_excl_l = 0, bins_excl_r = 0, extra_fe = NA,
  rn = NA, n_boot = 100, correct = TRUE, correct_above_zu = FALSE,
  correct_iter_max = 200, t0, t1, notch = FALSE, force_notch = FALSE,
  e_parametric = FALSE, e_parametric_lb = 1e-04, e_parametric_ub = 3,
  seed = NA, p_title = "", p_xtitle = deparse(substitute(z_vector)),
  p_ytitle = "Count", p_title_size = 11, p_axis_title_size = 10,
  p_axis_val_size = 8.5, p_miny = 0, p_maxy = NA, p_ybreaks = NA,
  p_freq_color = "black", p_cf_color = "maroon",
  p_zstar_color = "red", p_grid_major_y_color = "lightgrey",
  p_freq_size = 0.5, p_freq_msize = 1, p_cf_size = 0.5,
  p_zstar_size = 0.5, p_b = FALSE, p_e = FALSE, p_b_e_xpos = NA,
  p_b_e_ypos = NA, p_b_e_size = 3, p_domregion_color = "blue",
  p_domregion_ltype = "longdash")
}
\arguments{
\item{z_vector}{a numeric vector of (unbinned) data.}

\item{binv}{a string setting location of zstar within its bin ("min", "max" or "median" value). Default is median.}

\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{bins_l}{number of bins to left of zstar to use in analysis.}

\item{bins_r}{number of bins to right of zstar to use in analysis.}

\item{poly}{a numeric value for the order of polynomial for counterfactual fit. Default is 9.}

\item{bins_excl_l}{number of bins to left of zstar to include in bunching region. Default is 0.}

\item{bins_excl_r}{number of bins to right of zstar to include in bunching region. Default is 0.}

\item{extra_fe}{a numeric vector of bin values to control for using fixed effects. Default includes no controls.}

\item{rn}{a numeric vector of (up to 2) round numbers to control for. Default includes no controls.}

\item{n_boot}{number of bootstrapped iterations. Default is 100.}

\item{correct}{implements correction for integration constraint. Default is TRUE.}

\item{correct_above_zu}{if integration constraint correction is implemented, should counterfactual be shifted only above zu (upper bound of exclusion region)? Default is FALSE (i.e. shift from above zstar).}

\item{correct_iter_max}{maximum iterations for integration constraint correction. Default is 200.}

\item{t0}{numeric value setting the marginal (average) tax rate below zstar in a kink (notch) setting.}

\item{t1}{numeric value setting the marginal (average) tax rate above zstar in a kink (notch) setting.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{force_notch}{whether to enforce user's choice of zu (upper limit of bunching region) in a notch setting. Default is FALSE (zu set by setting bunching equal to missing mass).}

\item{e_parametric}{whether to estimate elasticity using parametric specification (quasi-linear and iso-elastic utility function). Default is FALSE (which estimates reduced-form approximation).}

\item{e_parametric_lb}{lower bound for elasticity estimate's solution using parametric specification in notch setting. Default is 1e-04.}

\item{e_parametric_ub}{upper bound for elasticity estimate's solution using parametric specification in notch setting. Default is 3.}

\item{seed}{a numeric value for bootstrap seed (random re-sampling of residuals). Default is NA.}

\item{p_title}{plot's title. Default is empty.}

\item{p_xtitle}{plot's x_axis label. Default is the name of z_vector.}

\item{p_ytitle}{plot's y_axis label. Default is "Count".}

\item{p_title_size}{size of plot's title. Default is 11.}

\item{p_axis_title_size}{size of plot's axes' title labels. Default is 10.}

\item{p_axis_val_size}{size of plot's axes' numeric labels. Default is 8.5.}

\item{p_miny}{plot's minimum y_axis value. Default is 0.}

\item{p_maxy}{plot's maximum y_axis value. Default is optimized internally.}

\item{p_ybreaks}{a numeric vector of y-axis values at which to add horizontal line markers in plot. Default is optimized internally.}

\item{p_freq_color}{plot's frequency line color. Default is "black".}

\item{p_cf_color}{plot's counterfactual line color. Default is "maroon".}

\item{p_zstar_color}{plot's bunching region marker lines color. Default is "red".}

\item{p_grid_major_y_color}{plot's y-axis major grid line color. Default is "lightgrey".}

\item{p_freq_size}{plot's frequency line thickness. Default is 0.5.}

\item{p_freq_msize}{plot's frequency line marker size. Default is 1.}

\item{p_cf_size}{plot's counterfactual line thickness. Default is 0.5.}

\item{p_zstar_size}{plot's bunching region marker line thickness. Default is 0.5.}

\item{p_b}{whether plot should also include the bunching estimate. Default is FALSE.}

\item{p_e}{whether plot should also include the elasticity estimate. Only shown if p_b is TRUE. Default is FALSE.}

\item{p_b_e_xpos}{plot's x-axis coordinate of bunching/elasticity estimate. Default is set internally.}

\item{p_b_e_ypos}{plot's y-axis coordinate of bunching/elasticity estimate. Default is set internally.}

\item{p_b_e_size}{size of plot's printed bunching/elasticity estimate. Default is 3.}

\item{p_domregion_color}{plot's dominated region marker line color in notch setting. Default is "blue".}

\item{p_domregion_ltype}{line type for the vertical line type marking the dominated region (zD) in the plot for notch settings. Default is "longdash".}
}
\value{
\code{bunchit} returns a list of results, both for visualizing and for further analysis of the data underlying the estimates. These include:
  \item{plot}{The bunching plot.}
  \item{data}{The binned data used for estimation.}
  \item{cf}{The estimated counterfactuals.}
  \item{B}{The estimated excess mass (not normalized).}
  \item{B_vector}{The vector of bootstrapped B's.}
  \item{B_sd}{The standard deviation of B_vector.}
  \item{b}{The estimated excess mass (normalized).}
  \item{b_vector}{The vector of bootstrapped b's.}
  \item{b_sd}{The standard deviation of b_vector.}
  \item{e}{The estimated elasticity.}
  \item{e_vector}{The vector of bootstrapped elasticities (e).}
  \item{e_sd}{The standard deviation of e_vector.}
  \item{alpha}{The estimated fraction of bunchers in dominated region (notch case).}
  \item{alpha_vector}{The vector of bootstrapped alphas.}
  \item{alpha_sd}{The standard deviation of alpha_vector.}
  \item{model_fit}{The model fit on the actual (i.e. not bootstrapped) data.}
  \item{zD}{The value demarcating the dominated region (notch case).}
  \item{zD_bin}{The bin above zstar demarcating the dominated region (notch case).}
  \item{zU_bin}{The location of zU (upper range of excluded region) as estimated from notch setting by setting force_notch = FALSE.}
  \item{marginal_buncher}{The location (z value) of the marginal buncher.}
  \item{marginal_buncher_vector}{The vector of bootstrapped marginal_buncher values.}
  \item{marginal_buncher_sd}{The standard deviation of marginal_buncher_vector.}
}
\description{
Implement the bunching estimator in a kink or notch setting.
}
\details{
bunchit implements the bunching estimator in both kink and notch settings. It bins a given numeric vector, fits a counterfactual density, and estimates the bunching mass (normalized and not), the elasticity and the location of the marginal buncher. In the case of notches, it also finds the dominated region and estimates the fraction of observations located in it.
}
\examples{
# First, load the example data
data(bunching_data)

# Example 1: Kink with integration constraint correction
kink1 <- bunchit(z_vector = bunching_data$kink, zstar = 10000, binwidth = 50,
                 bins_l = 20, bins_r = 20, poly = 4, t0 = 0, t1 = .2,
                 p_b = TRUE, seed = 1)
kink1$plot
kink1$b
kink1$b_sd

# Example 2: Kink with diffuse bunching
bpoint <- 10000; binwidth <- 50
kink2_vector <- c(bunching_data$kink_vector,
                 rep(bpoint - binwidth,80), rep(bpoint - 2*binwidth,190),
                 rep(bpoint + binwidth,80), rep(bpoint + 2*binwidth,80))
kink2 <- bunchit(z_vector = kink2_vector, zstar = 10000, binwidth = 50,
                 bins_l = 20, bins_r = 20, poly = 4,  t0 = 0, t1 = .2,
                 bins_excl_l = 2, bins_excl_r = 2, correct = FALSE,
                 p_b = TRUE, seed = 1)
kink2$plot

# Example 3: Kink with further bunching at other level in bandwidth
kink3_vector <- c(bunching_data$kink_vector, rep(10200,540))
kink3 <- bunchit(kink3_vector, zstar = 10000, binwidth = 50,
                 bins_l = 40, bins_r = 40, poly = 6, t0 = 0, t1 = .2,
                 correct = FALSE, p_b = TRUE, extra_fe = 10200, seed = 1)
kink3$plot

# Example 4: Kink with round number bunching
rn1 <- 500;  rn2 <- 250
bpoint <- 10000
kink4_vector <- c(bunching_data$kink_vector,
                  rep(bpoint + rn1, 270),
                  rep(bpoint + 2*rn1,230),
                  rep(bpoint - rn1,260),
                  rep(bpoint - 2*rn1,275),
                  rep(bpoint + rn2, 130),
                  rep(bpoint + 3*rn2,140),
                  rep(bpoint - rn2,120),
                  rep(bpoint - 3*rn2,135))
kink4 <- bunchit(z_vector = kink4_vector, zstar = bpoint, binwidth = 50,
                 bins_l = 20, bins_r = 20, poly = 6, t0 = 0, t1 = .2,
                 correct = FALSE, p_b = TRUE, p_e = TRUE, p_freq_msize = 1.5,
                 p_b_e_ypos = 880, rn = c(250,500), seed = 1)
kink4$plot

# Example 5: Notch
notch <- bunchit(z_vector = bunching_data$notch_vector, zstar = 10000, binwidth = 50,
                 bins_l = 40, bins_r = 40, poly = 5, t0 = 0.18, t1 = .25,
                 correct = FALSE, notch = TRUE,p_b = TRUE, p_b_e_xpos = 8900,
                 n_boot = 0)
notch$plot
}
\seealso{
\code{\link{plot_hist}}
}
