% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{run_sea}
\alias{run_sea}
\title{Perform superposed epoch analysis.}
\usage{
run_sea(x, key, years_before = 6, years_after = 4,
  time_span = c("key_period"), n_iter = 1000)
}
\arguments{
\item{x}{A data.frame climate reconstruction or tree-ring series with row names as years.}

\item{key}{A vector of event years for superposed epoch, such as fire years}

\item{years_before}{The number of lag years prior to the event year}

\item{years_after}{The number of lag years following the event year}

\item{time_span}{The length of the x time series to use. Defaults to "key_period"
which constrains the time series to the time period of key events; "all" will use the entire
time series}

\item{n_iter}{The number of iterations for bootstrap resampling}
}
\value{
A list of three data frames, following the output of EVENT.
(1) the actual events table, (2) the simulated events table, and (3) departures of actual from simulated
}
\description{
A superposed epoch analysis function that attempts to directly replicate the analyses provided in the EVENT program of the dendro
program library and FHX2. In effect, it uses the matrix calculations of the sea function in the dplR library
 with additional output.
}
\details{
It's superposed epoch analysis, it's all been said before. Twice.
}
\references{
Holmes and Swetnam 1994, EVENT program desription

Swetnam 1993, Fire history and climate change in giant sequoia groves, Science 262:885-889.

Bunn 2008, A dendrochronology program library in R (dplR), Dendrochronologia 26:115-124
}

