% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klaR.R
\name{axe-NaiveBayes}
\alias{axe-NaiveBayes}
\alias{axe_call.NaiveBayes}
\alias{axe_data.NaiveBayes}
\title{Axing a NaiveBayes.}
\usage{
\method{axe_call}{NaiveBayes}(x, verbose = FALSE, ...)

\method{axe_data}{NaiveBayes}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed NaiveBayes object.
}
\description{
NaiveBayes objects are created from the \pkg{klaR} package, leveraged to
fit a Naive Bayes Classifier.
}
\examples{
\dontshow{if (rlang::is_installed("klaR")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(klaR)

fit_mod <- function() {
  boop <- runif(1e6)
  NaiveBayes(
    y ~ x,
    data = data.frame(y = as.factor(rep(letters[1:4], 1e4)), x = rnorm(4e4))
  )
}

mod_fit <- fit_mod()
mod_res <- butcher(mod_fit)

weigh(mod_fit)
weigh(mod_res)

\dontshow{\}) # examplesIf}
}
