% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.bvar.R
\name{irf.bvar}
\alias{irf.bvar}
\title{Impulse Response Function}
\usage{
\method{irf}{bvar}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 5,
  ci = 0.95,
  shock = 1,
  type = "feir",
  cumulative = FALSE,
  keep_draws = FALSE,
  period = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"bvar"}, usually, a result of a call to
\code{\link{bvar}} or \code{\link{bvec_to_bvar}}.}

\item{impulse}{name of the impulse variable.}

\item{response}{name of the response variable.}

\item{n.ahead}{number of steps ahead.}

\item{ci}{a numeric between 0 and 1 specifying the probability mass covered by the
credible intervals. Defaults to 0.95.}

\item{shock}{size of the shock.}

\item{type}{type of the impulse resoponse. Possible choices are forecast error \code{"feir"}
(default), orthogonalised \code{"oir"}, structural \code{"sir"}, generalised \code{"gir"},
and structural generalised \code{"sgir"} impulse responses.}

\item{cumulative}{logical specifying whether a cumulative IRF should be calculated.}

\item{keep_draws}{logical specifying whether the function should return all draws of
the posterior impulse response function. Defaults to \code{FALSE} so that
the median and the credible intervals of the posterior draws are returned.}

\item{period}{integer. Index of the period, for which the IR should be generated.
Only used for TVP or SV models. Default is \code{NULL}, so that the posterior draws of the last time period
are used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A time-series object of class \code{"bvarirf"} and if \code{keep_draws = TRUE} a simple matrix.
}
\description{
Computes the impulse response coefficients of an object of class \code{"bvar"} for
\code{n.ahead} steps.
}
\details{
The function produces different types of impulse responses for the VAR model
\deqn{A_0 y_t = \sum_{i = 1}^{p} A_{i} y_{t-i} + u_t,}
with \eqn{u_t \sim N(0, \Sigma)}.

Forecast error impulse responses \eqn{\Phi_i} are obtained by recursions
\deqn{\Phi_i = \sum_{j = 1}^{i} \Phi_{i-j} A_j,   i = 1, 2,...,h}
with \eqn{\Phi_0 = I_K}.

Orthogonalised impulse responses \eqn{\Theta^o_i} are calculated as \eqn{\Theta^o_i = \Phi_i P},
where P is the lower triangular Choleski decomposition of \eqn{\Sigma}.

Structural impulse responses \eqn{\Theta^s_i} are calculated as \eqn{\Theta^s_i = \Phi_i A_0^{-1}}.

(Structural) Generalised impulse responses for variable \eqn{j}, i.e. \eqn{\Theta^g_ji} are calculated as
\eqn{\Theta^g_{ji} = \sigma_{jj}^{-1/2} \Phi_i A_0^{-1} \Sigma e_j}, where \eqn{\sigma_{jj}} is the variance
of the \eqn{j^{th}} diagonal element of \eqn{\Sigma} and \eqn{e_i} is a selection vector containing
one in its \eqn{j^{th}} element and zero otherwise. If the \code{"bvar"} object does not contain draws
of \eqn{A_0}, it is assumed to be an identity matrix.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Generate model data
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burnin should be much higher.

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

# Obtain IR
ir <- irf(object, impulse = "invest", response = "cons")

# Plot IR
plot(ir)


}
\references{
Lütkepohl, H. (2006). \emph{New introduction to multiple time series analysis} (2nd ed.). Berlin: Springer.

Pesaran, H. H., Shin, Y. (1998). Generalized impulse response analysis in linear multivariate models. \emph{Economics Letters, 58}, 17-29.
}
