% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin.dfm.R
\name{thin.dfm}
\alias{thin.dfm}
\title{Thinning Posterior Draws}
\usage{
\method{thin}{dfm}(x, thin = 10, ...)
}
\arguments{
\item{x}{an object of class \code{"dfm"}.}

\item{thin}{an integer specifying the thinning interval between successive values of posterior draws.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"dfm"}.
}
\description{
Thins the MCMC posterior draws in an object of class \code{"dfm"}.
}
\examples{

# Load data
data("bem_dfmdata")

# Generate model data
model <- gen_dfm(x = bem_dfmdata, p = 1, n = 1,
                 iterations = 20, burnin = 10)
# Number of iterations and burnin should be much higher.

# Add prior specifications
model <- add_priors(model,
                    lambda = list(v_i = .01),
                    sigma_u = list(shape = 5, rate = 4),
                    a = list(v_i = .01),
                    sigma_v = list(shape = 5, rate = 4))

# Obtain posterior draws
object <- draw_posterior(model)

# Plot factors
object <- thin(object, thin = 2)

}
