% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{choose_bayes}
\alias{choose_bayes}
\title{Finding the Set of Hyperparameters of Bayesian Model}
\usage{
choose_bayes(
  bayes_bound = bound_bvhar(),
  ...,
  eps = 1e-04,
  y,
  order = c(5, 22),
  include_mean = TRUE,
  parallel = list()
)
}
\arguments{
\item{bayes_bound}{Empirical Bayes optimization bound specification defined by \code{\link[=bound_bvhar]{bound_bvhar()}}.}

\item{...}{Additional arguments for \code{\link[stats:optim]{stats::optim()}}.}

\item{eps}{Hyperparameter \code{eps} is fixed. By default, \code{1e-04}.}

\item{y}{Time series data}

\item{order}{Order for BVAR or BVHAR. \code{p} of \code{\link[=bvar_minnesota]{bvar_minnesota()}} or \code{har} of \code{\link[=bvhar_minnesota]{bvhar_minnesota()}}. By default, \code{c(5, 22)} for \code{har}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{parallel}{List the same argument of \code{\link[optimParallel:optimParallel]{optimParallel::optimParallel()}}. By default, this is empty, and the function does not execute parallel computation.}
}
\value{
\code{bvharemp} \link{class} is a list that has
\describe{
\item{...}{Many components of \code{\link[stats:optim]{stats::optim()}} or \code{\link[optimParallel:optimParallel]{optimParallel::optimParallel()}}}
\item{spec}{Corresponding \code{bvharspec}}
\item{fit}{Chosen Bayesian model}
\item{ml}{Marginal likelihood of the final model}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} This function chooses the set of hyperparameters of Bayesian model using \code{\link[stats:optim]{stats::optim()}} function.
}
\references{
Giannone, D., Lenza, M., & Primiceri, G. E. (2015). \emph{Prior Selection for Vector Autoregressions}. Review of Economics and Statistics, 97(2).

Kim, Y. G., and Baek, C. (n.d.). \emph{Bayesian vector heterogeneous autoregressive modeling}. submitted.
}
\seealso{
\itemize{
\item \code{\link[=bound_bvhar]{bound_bvhar()}} to define L-BFGS-B optimization bounds.
\item Individual functions: \code{\link[=choose_bvar]{choose_bvar()}}
}
}
