% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-param.R
\name{sim_mncoef}
\alias{sim_mncoef}
\title{Generate Minnesota BVAR Parameters}
\usage{
sim_mncoef(p, bayes_spec = set_bvar(), full = TRUE)
}
\arguments{
\item{p}{VAR lag}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_bvar]{set_bvar()}}.}

\item{full}{Generate variance matrix from IW (default: \code{TRUE}) or not (\code{FALSE})?}
}
\value{
List with the following component.
\describe{
\item{coefficients}{BVAR coefficient (MN)}
\item{covmat}{BVAR variance (IW or diagonal matrix of \code{sigma} of \code{bayes_spec})}
}
}
\description{
This function generates parameters of BVAR with Minnesota prior.
}
\details{
Implementing dummy observation constructions,
Bańbura et al. (2010) sets Normal-IW prior.
\deqn{A \mid \Sigma_e \sim MN(A_0, \Omega_0, \Sigma_e)}
\deqn{\Sigma_e \sim IW(S_0, \alpha_0)}
If \code{full = FALSE}, the result of \eqn{\Sigma_e} is the same as input (\code{diag(sigma)}).
}
\examples{
# Generate (A, Sigma)
# BVAR(p = 2)
# sigma: 1, 1, 1
# lambda: .1
# delta: .1, .1, .1
# epsilon: 1e-04
set.seed(1)
sim_mncoef(
  p = 2,
  bayes_spec = set_bvar(
    sigma = rep(1, 3),
    lambda = .1,
    delta = rep(.1, 3),
    eps = 1e-04
  ),
  full = TRUE
)
}
\references{
Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).

Karlsson, S. (2013). \emph{Chapter 15 Forecasting with Bayesian Vector Autoregression}. Handbook of Economic Forecasting, 2, 791–897.

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.
}
\seealso{
\itemize{
\item \code{\link[=set_bvar]{set_bvar()}} to specify the hyperparameters of Minnesota prior.
\item \link{bvar_adding_dummy} for dummy observations definition.
}
}
