% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-models.R
\name{bvar_predictive_density}
\alias{bvar_predictive_density}
\title{Predictive Density of Bayesian Models}
\description{
This page explains the simulation algorithm for predictive distribution of BVAR and BVHAR.
}
\section{Simulating predictive distribution of BVAR}{
This simulation process is required because we do not know the closed form of h-step ahead forecasting density.
For given number of simulation (\code{n_iter}),
\enumerate{
\item Generate \eqn{(A^{(b)}, \Sigma_e^{(b)}) \sim MIW} (posterior)
\item Recursively, \eqn{j = 1, \ldots, h} (\code{n_ahead})
\itemize{
\item Point forecast: Use \eqn{\hat{A}}
\item Predictive distribution: Again generate \eqn{\tilde{Y}_{n + j}^{(b)} \sim A^{(b)}, \Sigma_e^{(b)} \sim MN}
\item tilde notation indicates simulated ones
}
}

Simulating predictive distribution of BVHAR

We extend the similar procedure in BVAR to the BVHAR.

For given number of simulation (\code{n_iter}),
\enumerate{
\item Generate \eqn{(\Phi^{(b)}, \Sigma_e^{(b)}) \sim MIW} (posterior)
\item Recursively, \eqn{j = 1, \ldots, h} (\code{n_ahead})
\itemize{
\item Point forecast: Use \eqn{\hat\Phi}
\item Predictive distribution: Again generate \eqn{\tilde{Y}_{n + j}^{(b)} \sim \Phi^{(b)}, \Sigma_e^{(b)} \sim MN}
\item tilde notation indicates simulated ones
}
}
}

\references{
Giannone, D., Lenza, M., & Primiceri, G. E. (2015). \emph{Prior Selection for Vector Autoregressions}. Review of Economics and Statistics, 97(2).

Karlsson, S. (2013). \emph{Chapter 15 Forecasting with Bayesian Vector Autoregression}. Handbook of Economic Forecasting, 2, 791–897.
}
\keyword{internal}
