% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-sparse.R
\name{spne}
\alias{spne}
\alias{spne.bvharsp}
\title{Evaluate the Estimation Based on Spectral Norm Error}
\usage{
spne(x, y, ...)

\method{spne}{bvharsp}(x, y, ...)
}
\arguments{
\item{x}{Estimated model.}

\item{y}{Coefficient matrix to be compared.}

\item{...}{not used}
}
\value{
Spectral norm value
}
\description{
This function computes estimation error given estimated model and true coefficient.
}
\details{
Let \eqn{\lVert \cdot \rVert_2} be the spectral norm of a matrix,
let \eqn{\hat{\Phi}} be the estimates,
and let \eqn{\Phi} be the true coefficients matrix.
Then the function computes estimation error by
\deqn{\lVert \hat{\Phi} - \Phi \rVert_2}
}
\references{
Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).
}
