% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-sparse.R
\name{conf_fdr}
\alias{conf_fdr}
\alias{conf_fdr.summary.bvharsp}
\title{Evaluate the Sparsity Estimation Based on FDR}
\usage{
conf_fdr(x, y, ...)

\method{conf_fdr}{summary.bvharsp}(x, y, truth_thr = 0, ...)
}
\arguments{
\item{x}{\code{summary.bvharsp} object.}

\item{y}{True inclusion variable.}

\item{...}{not used}

\item{truth_thr}{Threshold value when using non-sparse true coefficient matrix. By default, \code{0} for sparse matrix.}
}
\value{
FDR value in confusion table
}
\description{
This function computes false discovery rate (FDR) for sparse element of the true coefficients given threshold.
}
\details{
When using this function, the true coefficient matrix \eqn{\Phi} should be sparse.
False discovery rate (FDR) is computed by
\deqn{FDR = \frac{FP}{TP + FP}}
where TP is true positive, and FP is false positive.
}
\references{
Bai, R., & Ghosh, M. (2018). High-dimensional multivariate posterior consistency under global–local shrinkage priors. Journal of Multivariate Analysis, 167, 157–170.
}
\seealso{
\code{\link[=confusion]{confusion()}}
}
