% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{choose_ssvs}
\alias{choose_ssvs}
\title{Choose the Hyperparameters Set of SSVS-VAR using a Default Semiautomatic Approach}
\usage{
choose_ssvs(
  y,
  ord,
  type = c("VAR", "VHAR"),
  param = c(0.1, 10),
  include_mean = TRUE,
  gamma_param = c(0.01, 0.01),
  mean_non = 0,
  sd_non = 0.1
)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables.}

\item{ord}{Order for VAR or VHAR.}

\item{type}{Model type (Default: \code{VAR} or \code{VHAR}).}

\item{param}{Preselected constants \eqn{c_0 << c_1}. By default, \code{0.1} and \code{10} (See Details).}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE}).}

\item{gamma_param}{Parameters (shape, rate) for Gamma distribution. This is for the output.}

\item{mean_non}{Prior mean of unrestricted coefficients. This is for the output.}

\item{sd_non}{Standard deviance of unrestricted coefficients. This is for the output.}
}
\value{
\code{ssvsinput} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function chooses \eqn{(\tau_{0i}, \tau_{1i})} and \eqn{(\kappa_{0i}, \kappa_{1i})}
using a default semiautomatic approach.
}
\details{
Instead of using subjective values of \eqn{(\tau_{0i}, \tau_{1i})}, we can use
\deqn{\tau_{ki} = c_k \hat{VAR(OLS)}}
It must be \eqn{c_0 << c_1}.

In case of \eqn{(\omega_{0ij}, \omega_{1ij})},
\deqn{\omega_{kij} = c_k = \hat{VAR(OLS)}}
similarly.
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881-889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553-580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267-358.
}
