% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{mase}
\alias{mase}
\alias{mase.predbvhar}
\alias{mase.bvharcv}
\title{Evaluate the Model Based on MASE (Mean Absolute Scaled Error)}
\usage{
mase(x, y, ...)

\method{mase}{predbvhar}(x, y, ...)

\method{mase}{bvharcv}(x, y, ...)
}
\arguments{
\item{x}{Forecasting object}

\item{y}{Test data to be compared. should be the same format with the train data.}

\item{...}{not used}
}
\value{
MASE vector corresponding to each variable.
}
\description{
This function computes MASE given prediction result versus evaluation set.
}
\details{
Let \eqn{e_t = y_t - \hat{y}_t}.
Scaled error is defined by
\deqn{q_t = \frac{e_t}{\sum_{i = 2}^{n} \lvert Y_i - Y_{i - 1} \rvert / (n - 1)}}
so that the error can be free of the data scale.
Then

\deqn{MASE = mean(\lvert q_t \rvert)}

Here, \eqn{Y_i} are the points in the sample, i.e. errors are scaled by the in-sample mean absolute error (\eqn{mean(\lvert e_t \rvert)}) from the naive random walk forecasting.
}
\references{
Hyndman, R. J., & Koehler, A. B. (2006). \emph{Another look at measures of forecast accuracy}. International Journal of Forecasting, 22(4), 679-688.
}
