% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-sparse.R
\name{conf_fnr}
\alias{conf_fnr}
\alias{conf_fnr.summary.bvharsp}
\title{Evaluate the Sparsity Estimation Based on FNR}
\usage{
conf_fnr(x, y, ...)

\method{conf_fnr}{summary.bvharsp}(x, y, truth_thr = 0, ...)
}
\arguments{
\item{x}{\code{summary.bvharsp} object.}

\item{y}{True inclusion variable.}

\item{...}{not used}

\item{truth_thr}{Threshold value when using non-sparse true coefficient matrix. By default, \code{0} for sparse matrix.}
}
\value{
FNR value in confusion table
}
\description{
This function computes false negative rate (FNR) for sparse element of the true coefficients given threshold.
}
\details{
False negative rate (FNR) is computed by
\deqn{FNR = \frac{FN}{TP + FN}}
where TP is true positive, and FN is false negative.
}
\references{
Bai, R., & Ghosh, M. (2018). High-dimensional multivariate posterior consistency under global-local shrinkage priors. Journal of Multivariate Analysis, 167, 157-170.
}
\seealso{
\code{\link[=confusion]{confusion()}}
}
