% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bzinb.R
\name{weighted.pc}
\alias{weighted.pc}
\title{Weighted Pearson Correlation (WPC) based on bivariate zero-inflated 
negative binomial (BZINB) model}
\usage{
weighted.pc(xvec, yvec, param = NULL, ...)
}
\arguments{
\item{xvec, yvec}{a pair of bzinb random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{param}{a vector of parameters (\code{(a0, a1, a2, b1, b2, p1, p2, p3, p4)}). 
See \code{bzinb} for details.
If \code{param} is \code{null}, it will be estimated by \code{bzinb()}.}

\item{...}{optional arguments used passed to \code{bzinb}, when \code{param} is \code{null}.}
}
\value{
weighted Pearson correlation (WPC) estimate
}
\description{
weighted.pc calculates Pearson's correlation with less weights for pairs 
containing zero(s). The weights are determined by BZINB model.
}
\examples{
# generating a pair of random vectors
set.seed(2)
data1 <- rbzinb(n = 20, a0 = 1, a1 = 1, a2 = 1, 
                b1 = 1, b2 = 1, p1 = 0.5, p2 = 0.2, 
                p3 = 0.2, p4 = 0.1)

weighted.pc(xvec = data1[,1], yvec = data1[,2], 
            param = c(0.769, 0.041, 0.075, 3.225, 1.902, 0.5, 0.084, 1e-20, 0.416))
weighted.pc(xvec = data1[,1], yvec = data1[,2])

}
\references{
Cho, H., Preisser, J., Liu, C., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
