# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Solve an inital value problem with cvodes.
#' 
#'
#' @description Wrapper around the solver cvodes from the Sundials suite.
#'
#' @param times Numeric vector of time points at which integration results are returned.
#'
#' @param states_ Numeric vector of inital values for states.
#'
#' @param parameters_ Numeric vector of model parameters values.
#'
#' @param initSens_ Numeric vector of inital values for sensitivities.
#'
#' @param settings List of setting passed to cvodes. For a detailed documentation of the
#'     supported setting please check the
#'     \href{http://computation.llnl.gov/projects/sundials/sundials-software}{Sundials homepage}.
#'     Supported settings are
#'     \describe{
#'     \item{\code{"jacobian"}, bool.}{
#'     For \code{"jacobian" = TRUE}, a function returning the Jacobian matrix
#'     of the system must be provided by \option{jacobian_}.}
#'
#'     \item{\code{"method"}, string, can be \code{"bdf"} or \code{"adams"}.}{
#'     The integration method used. For "bdf" \code{CVodeCreate(CV_BDF, CV_NEWTON)}
#'     is called, for "adams" \code{CVodeCreate(CV_ADAMS, CV_NEWTON)}.}
#'
#'     \item{\code{"atol"}, a scalar or a vector.}{
#'     Specifies the absolute integration tolerance. If "atol" is scalar, each
#'     state is integrated with the same absolute tolerance. If the absolute
#'     error tolerance needs to be different for each state, "atol" can be a
#'     vector holding the tolerance for each state.}
#'
#'     \item{\code{"rtol"}, scalar.}{
#'     Relative integration error tolerance.}
#'
#'     \item{\code{"which_states"}, vector.}{
#'     Return the first \code{"which_states"}. If the model has \code{N} states,
#'     \code{which_states <= N} allows to dicard all states
#'     \code{> which_states}
#'     }
#'
#'     \item{\code{"which_observed"}, vector.}{
#'     Same as \code{"which_states"}, but for observables.
#'     }
#'
#'     \item{\code{"maxsteps" = 500}, scalar.}{
#'     Maximum number of internal steps allowed to reach the next output time.
#'     While not recommended, this test can be disabled by passing
#'     \code{"maxsteps" < 0}.}
#'
#'     \item{\code{"maxord" = 12 (adams) or 5 (bdf)}, scalar.}{
#'     Maximum order of the linear multistep method. Can only be set to smaller
#'     values than default.}
#'
#'     \item{\code{"hini" = "estimated"}, scalar.}{
#'     Inital step size.}
#'
#'     \item{\code{"hmin" = 0.0}, scalar.}{
#'     Minimum absolute step size.}
#'
#'     \item{\code{"hmax" = infinity}, scalar.}{
#'     Maximum absolute step size.}
#'
#'     \item{\code{"maxerr"} = 7, scalar.}{
#'     Permitted maximum number of failed error test per step.}
#'
#'     \item{\code{"maxnonlin" = 3}, scalar.}{
#'     Permitted nonlinear solver iterations per step.}
#'
#'     \item{\code{"maxconvfail" = 10}, scalar.}{
#'     Permitted convergence failures of the nonlinear solver per step.}
#'
#'     \item{\code{"stability"} = FALSE, bool.}{
#'     Stability limit detection for the "bdf" method.}
#'
#'     \item{\code{"positive"}, bool.}{
#'     Issue an error (and abort?) in case a state becomes smaller than
#'     \option{"minimum"}.}
#'
#'     \item{\code{"minimum"}, scalar.}{
#'     Lower bound below which a state is assumed negative and reported, in
#'     case \option{\code{"positive" = TRUE}}.}
#'
#'     \item{\code{"sensitivities"} = FALSE, bool.}{
#'     Integrate sensitivities of the dynamic system.}
#'     }
#'
#' @param model_ The address of the ode model. The address is obtained as the
#'     attribute \code{address} of \code{\link[base]{getNativeSymbolInfo}}. The
#'     signature of the model function must comply to
#'
#'     \code{std::array<std::vector<double>, 2> (const double& t, const std::vector<double>&
#'     states,
#'     const std::vector<double>& parameters, const std::vector<double>& forcings)}
#'
#'     Return vector \code{std::array<std::vector<double>, 2>}
#'     \enumerate{
#'     \item
#'     First dimension holds the increments for all
#'     states.
#'     \item
#'     Second dimension holds the observed state. Not sure what these are.
#'     }
#'
#'     Argument list
#'     \code{(const double& t, const std::vector<double>& states,
#'     const std::vector<double>& parameters, const std::vector<double>& forcings)}
#'     \describe{
#'     \item{t}{
#'     Most probably the requested time point, but I am not totally sure.}
#'
#'     \item{states}{
#'     Vector of current state values.}
#'
#'     \item{parameters}{
#'     Vector of parameters values.}
#'
#'     \item{forcings}{
#'     Vector of forcings acting on the model.}
#'     }
#'
#' @param sens_ The address of the function which returns the right-hand side of the
#'     sensitivity equations. Again, this address is the attribute \code{address} obtained
#'     from the call to \code{\link[base]{getNativeSymbolInfo}}. The list of arguments is the 
#'     same as for \option{model_}.
#'     
#' @param events_ Data.frame with columns \code{var} (index of the ODE state in the vector
#'     of states.), \code{time} (time point of the event), \code{method} (one of "replace", 
#'     "add", or "multiply"), \code{value} (value associated with the event).
#'     
#' @param jacobian_ The address of the function which returns the Jacobian matrix of the
#'     model. Again, this address is the attribute \code{address} obtained
#'     from the call to \code{\link[base]{getNativeSymbolInfo}}. The function
#'     must have the signature
#'     \code{arma::mat (const double& t, const std::vector<double>& states, const
#'     std::vector<double>& parameters, const std::vector<double>& forcings)}
#'     Returned is the Jacobian matrix as an \code{arma::mat} from the
#'     Armadillo package.
#'
#'     The list of arguments is the same as for \option{model_}.
#'
#' @details This function sets up the cvodes integrator and loop over the
#'     vector \option{times} of requested time points. On success, the states
#'     of the system are returend for these time points.
#'
#'     Write something about these observations, once you got a hold of them.
#'
#' @return Matrix with nrow = (no. timepoints) and
#'     ncol = (no. states + no. observed + [(no. states)x(no. parameters)]).
#'     [(no. states)x(no. parameters)] is only returned if sensitivity equations
#'     are calculated.
#'
#'     \describe{
#'     \item{First column}{
#'     Integration time points as given in \option{times}.}
#'
#'     \item{Column 2 to no. of states + 1}{
#'     The state for the respective time point.}
#'
#'     \item{no. of states + 1 to number of states + 1 + n. of observations}{
#'     Observation for the respective time point.}
#'     }
#'
#' @author Alejandro Morales, \email{morales.s.alejandro@@gmail.com}
#'
#' @export
wrap_cvodes <- function(times, states_, parameters_, initSens_, events_, settings, model_, jacobian_, sens_) {
    .Call('_cOde_wrap_cvodes', PACKAGE = 'cOde', times, states_, parameters_, initSens_, events_, settings, model_, jacobian_, sens_)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_cOde_RcppExport_registerCCallable', PACKAGE = 'cOde')
})
