% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateHTMT}
\alias{calculateHTMT}
\title{Internal: HTMT}
\usage{
calculateHTMT(
 .object              = NULL,
 .only_common_factors = TRUE
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}
}
\value{
A lower tringular matrix of HTMT values.
}
\description{
Compute the heterotrait-monotrait ratio of correlations (HTMT) based on
\insertCite{Henseler2015;textual}{cSEM}.
}
\details{
Similarly to the Cronbach's alpha, the HTMT is a consistent estimator for the
construct correlations in case of tau equivalent measurement models.

The HTMT is used to assess discriminant validity.

The function is only applicable to objects inheriting class \code{cSEMResults_default}.
For objects of class \code{cSEMResults_multi} and \code{cSEMResults_2ndorder} use \code{\link[=assess]{assess()}}.
}
\seealso{
\code{\link[=assess]{assess()}}, \link{csem}, \link{cSEMResults}
}
\keyword{internal}
