% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-boot-beta-std.R
\name{BootBetaStd}
\alias{BootBetaStd}
\title{Bootstrap Sampling Distribution
for the Elements of the Standardized Matrix
of Lagged Coefficients
Over a Specific Time Interval
or a Range of Time Intervals}
\usage{
BootBetaStd(phi, sigma, phi_hat, sigma_hat, delta_t, ncores = NULL, tol = 0.01)
}
\arguments{
\item{phi}{List of numeric matrices.
Each element of the list is a bootstrap estimate
of the drift matrix (\eqn{\boldsymbol{\Phi}}).}

\item{sigma}{List of numeric matrices.
Each element of the list is a bootstrap estimate
of the process noise covariance matrix
(\eqn{\boldsymbol{\Sigma}}).}

\item{phi_hat}{Numeric matrix.
The estimated drift matrix (\eqn{\hat{\boldsymbol{\Phi}}})
from the original data set.
\code{phi_hat} should have row and column names
pertaining to the variables in the system.}

\item{sigma_hat}{Numeric matrix.
The estimated process noise covariance matrix
(\eqn{\hat{\boldsymbol{\Sigma}}})
from the original data set.}

\item{delta_t}{Numeric.
Time interval
(\eqn{\Delta t}).}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL},
use a single core.
Consider using multiple cores
when number of replications \code{R}
is a large value.}

\item{tol}{Numeric.
Smallest possible time interval to allow.}
}
\value{
Returns an object
of class \code{ctmedboot} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("BootBetaStd").}
\item{output}{A list with length of \code{length(delta_t)}.}
}
Each element in the \code{output} list has the following elements:
\describe{
\item{est}{Estimated elements of the standardized matrix
of lagged coefficients.}
\item{thetahatstar}{A matrix of bootstrap
elements of the standardized matrix of lagged coefficients.}
}
}
\description{
This function generates a bootstrap method
sampling distribution
for the elements of the standardized matrix
of lagged coefficients
\eqn{\boldsymbol{\beta}}
over a specific time interval \eqn{\Delta t}
or a range of time intervals
using the first-order stochastic differential equation model
drift matrix \eqn{\boldsymbol{\Phi}}.
}
\details{
See \code{\link[=TotalStd]{TotalStd()}}.
}
\examples{
\dontrun{
library(simStateSpace)
# prepare parameters
## number of individuals
n <- 50
## time points
time <- 100
delta_t <- 0.10
## dynamic structure
p <- 3
mu0 <- rep(x = 0, times = p)
sigma0 <- matrix(
  data = c(
    1.0,
    0.2,
    0.2,
    0.2,
    1.0,
    0.2,
    0.2,
    0.2,
    1.0
  ),
  nrow = p
)
sigma0_l <- t(chol(sigma0))
mu <- rep(x = 0, times = p)
phi <- matrix(
  data = c(
    -0.357,
    0.771,
    -0.450,
    0.0,
    -0.511,
    0.729,
    0,
    0,
    -0.693
  ),
  nrow = p
)
sigma <- matrix(
  data = c(
    0.24455556,
    0.02201587,
    -0.05004762,
    0.02201587,
    0.07067800,
    0.01539456,
    -0.05004762,
    0.01539456,
    0.07553061
  ),
  nrow = p
)
sigma_l <- t(chol(sigma))
## measurement model
k <- 3
nu <- rep(x = 0, times = k)
lambda <- diag(k)
theta <- 0.2 * diag(k)
theta_l <- t(chol(theta))

boot <- PBSSMOUFixed(
  R = 1000L,
  path = getwd(),
  prefix = "ou",
  n = n,
  time = time,
  delta_t = delta_t,
  mu0 = mu0,
  sigma0_l = sigma0_l,
  mu = mu,
  phi = phi,
  sigma_l = sigma_l,
  nu = nu,
  lambda = lambda,
  theta_l = theta_l,
  ncores = parallel::detectCores() - 1,
  seed = 42
)
phi_hat <- phi
colnames(phi_hat) <- rownames(phi_hat) <- c("x", "m", "y")
sigma_hat <- sigma
phi <- extract(object = boot, what = "phi")
sigma <- extract(object = boot, what = "sigma")

# Specific time interval ----------------------------------------------------
BootBetaStd(
  phi = phi,
  sigma = sigma,
  phi_hat = phi_hat,
  sigma_hat = sigma_hat,
  delta_t = 1
)

# Range of time intervals ---------------------------------------------------
boot <- BootBetaStd(
  phi = phi,
  sigma = sigma,
  phi_hat = phi_hat,
  sigma_hat = sigma_hat,
  delta_t = 1:5
)
plot(boot)
plot(boot, type = "bc") # bias-corrected

# Methods -------------------------------------------------------------------
# BootBetaStd has a number of methods including
# print, summary, confint, and plot
print(boot)
summary(boot)
confint(boot, level = 0.95)
print(boot, type = "bc") # bias-corrected
summary(boot, type = "bc")
confint(boot, level = 0.95, type = "bc")
}

}
\references{
Bollen, K. A. (1987).
Total, direct, and indirect effects in structural equation models.
Sociological Methodology, 17, 37.
\doi{10.2307/271028}

Deboeck, P. R., & Preacher, K. J. (2015).
No need to be discrete:
A method for continuous time mediation analysis.
Structural Equation Modeling: A Multidisciplinary Journal, 23 (1), 61–75.
\doi{10.1080/10705511.2014.973960}

Ryan, O., & Hamaker, E. L. (2021).
Time to intervene:
A continuous-time approach to network analysis and centrality.
Psychometrika, 87 (1), 214–252.
\doi{10.1007/s11336-021-09767-0}
}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{BootBeta}()},
\code{\link{BootMed}()},
\code{\link{BootMedStd}()},
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaMedStd}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{DirectStd}()},
\code{\link{ExpCov}()},
\code{\link{ExpMean}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{TotalStd}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{boot}
\keyword{cTMed}
\keyword{path}
