% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-total-central.R
\name{TotalCentral}
\alias{TotalCentral}
\title{Total Effect Centrality}
\usage{
TotalCentral(phi, delta_t, tol = 0.01)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{delta_t}{Vector of positive numbers.
Time interval
(\eqn{\Delta t}).}

\item{tol}{Numeric.
Smallest possible time interval to allow.}
}
\value{
Returns an object
of class \code{ctmedmed} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("TotalCentral").}
\item{output}{A matrix of total effect centrality.}
}
}
\description{
Total Effect Centrality
}
\details{
The total effect centrality of a variable
is the sum of the total effects of a variable on all other variables
at a particular time interval.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")

# Specific time interval ----------------------------------------------------
TotalCentral(
  phi = phi,
  delta_t = 1
)

# Range of time intervals ---------------------------------------------------
total_central <- TotalCentral(
  phi = phi,
  delta_t = 1:30
)
plot(total_central)

# Methods -------------------------------------------------------------------
# TotalCentral has a number of methods including
# print, summary, and plot
total_central <- TotalCentral(
  phi = phi,
  delta_t = 1:5
)
print(total_central)
summary(total_central)
plot(total_central)

}
\references{
Bollen, K. A. (1987).
Total, direct, and indirect effects in structural equation models.
Sociological Methodology, 17, 37.
\doi{10.2307/271028}

Deboeck, P. R., & Preacher, K. J. (2015).
No need to be discrete:
A method for continuous time mediation analysis.
Structural Equation Modeling: A Multidisciplinary Journal, 23 (1), 61–75.
\doi{10.1080/10705511.2014.973960}

Ryan, O., & Hamaker, E. L. (2021).
Time to intervene:
A continuous-time approach to network analysis and centrality.
Psychometrika, 87 (1), 214–252.
\doi{10.1007/s11336-021-09767-0}
}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{BootBeta}()},
\code{\link{BootBetaStd}()},
\code{\link{BootIndirectCentral}()},
\code{\link{BootMed}()},
\code{\link{BootMedStd}()},
\code{\link{BootTotalCentral}()},
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaMedStd}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{DirectStd}()},
\code{\link{ExpCov}()},
\code{\link{ExpMean}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCPhiSigma}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalStd}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{effects}
\keyword{network}
