% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsize.R
\name{downsize}
\alias{downsize}
\title{Downsizing of a population to only one individual per box up to a given accuracy}
\usage{
downsize(points, Fo, prec)
}
\arguments{
\item{points}{: matrix of objectives}

\item{Fo}{: rank on the front of each point (1: dominates on the Pareto)}

\item{prec}{: (double, length = nobj) desired accuracy for sorting objectives}
}
\value{
vector indices
}
\description{
reduces the number of individuals in a population to only one individual per box up to a given accuracy
}
\examples{
# Definition of the parameters
points <- matrix(rexp(200), 100, 2)
prec <- c(1.e-3, 1.e-3)
Fo <- sample(1:100, 100)
# Call the function
res <- downsize(points, Fo, prec)

}
\author{
Fabrice Zaoui
}
