% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lenLCSStrict.r
\name{lenLCSStrict}
\alias{lenLCSStrict}
\title{Calculate the length of the longest common subsequence (KCS) between a string and a vector/list of strings.
Subsequences cannot be interrupted by any item,
i.e. q-w is not considered a subsequence of q-e-w-r due to the interrupting 'e'}
\usage{
lenLCSStrict(vecA, listB, sep = "-", dropFirstItem = FALSE)
}
\arguments{
\item{vecA}{The single string}

\item{listB}{The vector/list of 1 or more strings}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}
}
\value{
A list of vectors of the length of each common subsequence
}
\description{
Calculate the length of the longest common subsequence (KCS) between a string and a vector/list of strings.
Subsequences cannot be interrupted by any item,
i.e. q-w is not considered a subsequence of q-e-w-r due to the interrupting 'e'
}
\examples{
lenACSStrict("q-w-e-r", c("q-e-w-r","q-r-e-w","q-w-r-e"), "-")
lenACSStrict("itemToBeDropped-q-w-e-r", "itemToBeDroped-q-e-w-r", "-", dropFirstItem=TRUE)

}

