% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granularities.R
\name{granularity_names}
\alias{granularity_names}
\alias{granularity}
\title{Canonical granularities}
\usage{
granularity_names(calendar)

granularity(date, granularity)
}
\arguments{
\item{calendar}{A calcal object defining a calendar.}

\item{date}{A date vector on some calendar}

\item{granularity}{A character string indicating the granularity to extract}
}
\value{
A character vector of granularity names or a vector of numerical values for the specified granularity.
}
\description{
\code{granularities()} will return a character vector of canonical granularity names for the
relevant calendar. These are the granularities used to define dates on the calendar.
\code{granularity()} will return a vector of numerical values for a given canonical granularity.
}
\examples{
granularity_names(cal_iso)
granularity_names(cal_gregorian)
date_iso <- new_date(year = 2025, week = 23, day = 2, calendar = cal_iso)
granularity(date_iso, "week")
date_gregorian <- new_date(year = 2025, month = 1, day = 1, calendar = cal_gregorian)
granularity(date_gregorian, "month")
}
\seealso{
\link{week_of_year} for some non-canonical granularities.
}
