% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_action_group}
\alias{calcite_action_group}
\title{Create a ActionGroup component}
\usage{
calcite_action_group(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a ActionGroup component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   columns \tab columns \tab Indicates number of columns. \tab 1 | 2 | 3 | 4 | 5 | 6 \tab TRUE \cr
   expanded \tab expanded \tab When \code{true}, the component is expanded. \tab boolean \tab TRUE \cr
   label \tab label \tab Accessible name for the component. \tab string \tab FALSE \cr
   layout \tab layout \tab Indicates the layout of the component. \tab "grid" | "horizontal" | "vertical" \tab TRUE \cr
   menuFlipPlacements \tab NA \tab Specifies the component's fallback menu \code{placement} when it's initial or specified \code{placement} has insufficient space available. \tab Check API reference \tab FALSE \cr
   menuOpen \tab menu-open \tab When \code{true}, the \code{calcite-action-menu} is open. \tab boolean \tab TRUE \cr
   menuPlacement \tab menu-placement \tab Determines where the action menu will be positioned. \tab "auto" | "auto-end" | "auto-start" | "bottom" | "bottom-end" | "bottom-start" | "leading" | "leading-end" | "leading-start" | "left" | "left-end" | "left-start" | "right" | "right-end" | "right-start" | "top" | "top-end" | "top-start" | "trailing" | "trailing-end" | "trailing-start" \tab TRUE \cr
   messageOverrides \tab NA \tab Use this property to override individual strings used by the component. \tab Check API reference \tab FALSE \cr
   overlayPositioning \tab overlay-positioning \tab Determines the type of positioning to use for the overlaid content.  Using \code{"absolute"} will work for most cases. The component will be positioned inside of overflowing parent containers and will affect the container's layout. \code{"fixed"} should be used to escape an overflowing parent container, or when the reference element's \code{position} CSS property is \code{"fixed"}. \tab "absolute" | "fixed" \tab TRUE \cr
   scale \tab scale \tab Specifies the size of the \code{calcite-action-menu}. \tab "l" | "m" | "s" \tab TRUE \cr
}

}

\subsection{Slots}{

The following slots are provided by this component:\tabular{ll}{
   Slot \tab Description \cr
   Default (unnamed) \tab A slot for adding a group of \code{calcite-action}s. \cr
   menu-actions \tab A slot for adding an overflow menu with \code{calcite-action}s inside a \code{calcite-dropdown}. \cr
   menu-tooltip \tab A slot for adding a \code{calcite-tooltip} for the menu. \cr
}

}
}
\examples{
calcite_action_group()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/action-group/}{Official Documentation}
}
