% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integral.R
\name{integral}
\alias{integral}
\title{Monte Carlo Integration}
\usage{
integral(f, ..., err = 0.01, rel = TRUE, coordinates = "cartesian",
  verbose = TRUE)
}
\arguments{
\item{f}{function, expression or characters.}

\item{...}{integration bounds.}

\item{err}{acuracy requested.}

\item{rel}{logical. Relative accuracy? If \code{FALSE}, use absolute accuracy.}

\item{coordinates}{coordinate system to use. One of: \code{cartesian}, \code{polar}, \code{spherical}, \code{cylindrical}, \code{parabolic}, \code{parabolic-cylindrical} or a character vector of scale factors for each varibale.}

\item{verbose}{logical. Print on progress?}
}
\value{
list with components
\describe{
 \item{value}{the final estimate of the integral.}
 \item{abs.error}{estimate of the modulus of the absolute error.}
}
}
\description{
Integrates multidimensional functions, expressions, and characters in arbitrary \href{https://en.wikipedia.org/wiki/Orthogonal_coordinates#Table_of_orthogonal_coordinates}{orthogonal coordinate systems}.
}
\examples{
# integrate character
integral('sin(x)', x = c(0,2*pi), rel = FALSE)

# integrate expression
integral(parse(text = 'x'), x = c(0,1))

# integrate function
integral(function(x) exp(x), x = c(0,1))

# multivariate integral
integral(function(x,y) x*y, x = c(0,1), y = c(0,1))

# surface of a sphere
integral('1', r = 1, theta = c(0,pi), phi = c(0,2*pi), coordinates = 'spherical')

# volume of a sphere
integral('1', r = c(0,1), theta = c(0,pi), phi = c(0,2*pi), coordinates = 'spherical')

##################################
# Electric charge contained in a region of space
# (see divergence theorem and Maxwell's equations)
# 

# electric potential of unitary point charge 
V <- '1/(4*pi*r)'

# electric field
E <- -1 \%prod\% gradient(V, c('r', 'theta', 'phi'), coordinates = 'spherical')

# electric charge
integral(E[1], r = 1, theta = c(0,pi), phi = c(0,2*pi), coordinates = 'spherical')


}
