% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calibraR-main.R
\docType{package}
\name{calibrar-package}
\alias{calibrar}
\alias{calibrar-package}
\title{Automated Calibration for Complex (Ecological) Models}
\description{
Automated Calibration for Complex (Ecological) Models
}
\examples{
\dontrun{
require(calibrar)
set.seed(880820)
path = NULL # NULL to use the current directory
# create the demonstration files
demo = calibrarDemo(model="PoissonMixedModel", L=5, T=100)
# get calibration information
calibrationInfo = getCalibrationInfo(path=demo$path)
# get observed data
observed = getObservedData(info=calibrationInfo, path=demo$path)
# read forcings for the model
forcing = read.csv(file.path(demo$path, "master", "environment.csv"), row.names=1)
# Defining 'runModel' function
runModel = function(par, forcing) {
output = calibrar:::.PoissonMixedModel(par=par, forcing=forcing)
# adding gamma parameters for penalties
output = c(output, list(gammas=par$gamma))
return(output)
}
# real parameters
cat("Real parameters used to simulate data\\n")
print(demo$par)
# objective functions
obj  = createObjectiveFunction(runModel=runModel, info=calibrationInfo,
                               observed=observed, forcing=forcing)
cat("Starting calibration...\\n")
control = list(weights=calibrationInfo$weights, maxit=3.6e5) # control parameters
cat("Running optimization algorithms\\n", "\\t", date(), "\\n")
cat("Running optim AHR-ES\\n")
ahr = calibrate(par=demo$guess, fn=obj, lower=demo$lower, upper=demo$upper, control=control)
summary(ahr)
}
}
\author{
Ricardo Oliveros-Ramos Maintainer: Ricardo Oliveros-Ramos
<ricardo.oliveros@gmail.com>
}
\references{
calibrar: an R package for the calibration of ecological models (Oliveros-Ramos and Shin 2014)
}
\keyword{calibration}

