% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile}
\alias{compile}
\title{Compile C code and create wrapper functions to call from R}
\usage{
compile(
  code,
  CFLAGS = NULL,
  PKG_CPPFLAGS = NULL,
  PKG_LIBS = NULL,
  env = parent.frame(),
  overwrite = "callme",
  verbosity = 0,
  invisible = FALSE
)
}
\arguments{
\item{code}{C code following the \code{.Call()} conventions, or a filename
containing this code. This code must also include 
any \code{#include} statements - include \code{<R.h>} and
\code{<Rinternals.h>} at the very least.}

\item{CFLAGS}{character string of flags for the C compiler. e.g. "-O3"
Default: NULL.  If specified this value will \emph{replace} the
default \code{CFLAGS} R would normally use.  To see these default
flags use \code{cflags_default()}.}

\item{PKG_CPPFLAGS}{character string of flags for the C pre-processor.
Flags such as "-I", "-D" and "-U" go here.
Default: NULL
e.g. \code{PKG_CPPFLAGS = "-I/opt/homebrew/include"} to add the include path 
for homebrew to the compilation step.}

\item{PKG_LIBS}{character string of flags for linking. "-L" and "-l" flags
go here. Default: NULL.
e.g. \code{PKG_LIBS = "-L/opt/homebrew/lib -lzstd"} to include the homebrew 
libraries in the linker search path and to link to the \code{zstd}
library installed there.}

\item{env}{environment into which to assign the R wrapper functions.
Default: \code{parent.frame()}.  If \code{NULL} then no 
assignment takes place and the (invisible) return value should
be assigned to a variable to access the compiled code.}

\item{overwrite}{Which existing variables can be overwritten when wrapper 
functions are created in the given environment? An error will be
raised if the name of the wrapper function already exists in 
the environment and permission has not been given to overwrite.}

\item{verbosity}{Level of output: Default: 0. Max level: 4}

\item{invisible}{Should the R wrapper function return the result invisibly?
       Default: FALSE.  Set this to \code{TRUE} if the code is only 
       run for its side-effect e.g. just printing data and not returning anything.
\describe{
\item{"callme"}{(Default) Only functions created by this package can be overwritten}
\item{"all"}{All objects can be overwritten}
\item{"functions"}{Only functions can be overwritten}
\item{"none"}{No existing objects can be overwritten}
}}
}
\value{
Invisibly returns a named list of R functions. Each R function 
        calls to the equivalent C function.  If \code{env} is specified, 
        then these wrapper functions are assigned in the given 
        environment.
}
\description{
This function uses the \code{R CMD SHLIB} process to compile
C code into a linked library.  This library is then loaded, and 
appropriate functions created in R to call into this library.  See also: \code{?SHLIB}
}
\examples{
code <- "
#include <R.h>
#include <Rinternals.h>

// Add 2 numbers
SEXP add(SEXP val1, SEXP val2) {
  return ScalarReal(asReal(val1) + asReal(val2));
}

// Multiply 2 numbers
SEXP mul(SEXP val1, SEXP val2) {
  return ScalarReal(asReal(val1) * asReal(val2));
}

// sqrt elements in a vector
SEXP new_sqrt(SEXP vec) {
  SEXP res = PROTECT(allocVector(REALSXP, length(vec)));
  double *res_ptr = REAL(res);
  double *vec_ptr = REAL(vec);
  for (int i = 0; i < length(vec); i++) {
    res_ptr[i] = sqrt(vec_ptr[i]);
  }
  
  UNPROTECT(1);
  return res;
}
"

# compile the code and load into R
compile(code)

# Call the functions
add(99.5, 0.5)
mul(99.5, 0.5)
new_sqrt(c(1, 10, 100, 1000))
       
}
