% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calpassapi.R
\name{calpass_query}
\alias{calpass_query}
\alias{calpass_query_many}
\title{Query data from CalPASS API endpoints}
\usage{
calpass_query(interSegmentKey, token,
  api_url = "https://mmap.calpassplus.org/api", endpoint = c("transcript",
  "placement"))

calpass_query_many(interSegmentKey, token,
  api_url = "https://mmap.calpassplus.org/api", endpoint = c("transcript",
  "placement"))
}
\arguments{
\item{interSegmentKey}{for \code{calpass_query}, a single interSegmentKey; for \code{calpass_query_many}, a vector of interSgementKey's.  The interSegmentKey's can be created from \link[calpassapi]{calpass_create_isk}.}

\item{token}{a token string created from \link[calpassapi]{calpass_get_token}.}

\item{api_url}{defaults to \code{'https://mmap.calpassplus.org/api'}, but can be overrode if CalPASS changes the url.}

\item{endpoint}{the api endpoint to use; defaults to \code{'transcript'}.}
}
\value{
a data frame with columns \code{interSegmentKey}, \code{status_code} (the http response code: 200 means student was found, 204 means student was not found, 429 means the api limit was reached and student was not processed, and anything else in the 400's correspond to http errors.)
}
\description{
Query data from CalPASS API endpoints for a single interSegmentKey
}
\section{Functions}{
\itemize{
\item \code{calpass_query_many}: Query data from CalPASS API endpoints with a vector of interSegmentKey's.  The number of rows returned corresponds to the number of unique interSegmentKey's.
}}

\examples{
\dontrun{
## get access token
cp_token <- calpass_get_token(username='my_cp_api_uid', password='my_cp_api_pwd')

## single run
isk <- calpass_create_isk(first_name='Jane', last_name='Doe'
  , gender='F', birthdate=20001231)
calpass_query(interSegmentKey=isk
  , token=cp_token, endpoint='transcript')
calpass_query(interSegmentKey=isk
  , token=cp_token, endpoint='placement')

## multiple
firstname <- c('Tom', 'Jane', 'Jo')
lastname <- c('Ng', 'Doe', 'Smith')
gender <- c('Male', 'Female', 'X')
birthdate <- c(20001231, 19990101, 19981111)
df <- data.frame(firstname, lastname
  , gender, birthdate, stringsAsFactors=FALSE)
library(dplyr)
df \%>\%
  mutate(isk=calpass_create_isk(first_name=firstname
    , last_name=lastname
    , gender=gender
    , birthdate
  )) 
dfResults <- calpass_query(interSegmentKey=df$isk
  , token=cp_token
  , endpoint='transcript'
)
}
}
\references{
\href{https://mmap.calpassplus.org/docs/index.html}{MMAP API V1}
}
\author{
Vinh Nguyen
}
