% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{prop_distinct}
\alias{prop_distinct}
\title{Proportion missing}
\usage{
prop_distinct(x)
}
\arguments{
\item{x}{A vector to check.}
}
\value{
The ratio of distinct values \code{x} to total values of \code{x}.
}
\description{
Find the proportion of values of \code{x} that are distinct.
}
\details{
\code{length(unique(x))/length(x)}
}
\examples{
prop_distinct(c("VT", "VT", NA, "ME"))
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
