% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-city.R
\name{normal_city}
\alias{normal_city}
\title{Normalize city names}
\usage{
normal_city(city, abbs = NULL, states = NULL, na = c("", "NA"), na_rep = FALSE)
}
\arguments{
\item{city}{A vector of city names.}

\item{abbs}{A named vector or data frame of abbreviations passed to
\link{expand_abbrev}; see \link{expand_abbrev} for format of \code{abb} argument or use
the \link{usps_city} tibble.}

\item{states}{A vector of state abbreviations ("VT") to remove from the
\emph{end} (and only end) of city names ("STOWE VT").}

\item{na}{A vector of values to make \code{NA} (useful with the \link{invalid_city}
vector).}

\item{na_rep}{logical; If \code{TRUE}, replace all single digit (repeating)
strings with \code{NA}.}
}
\value{
A vector of normalized city names.
}
\description{
Return consistent version of a city names using \verb{stringr::str_*()} functions.
Letters are capitalized, hyphens and underscores are replaced with
whitespace, other punctuation is removed, numbers are removed, and excess
whitespace is trimmed and squished. Optionally, geographic abbreviations
("MT") can be replaced with their long form ("MOUNT"). Invalid addresses from
a vector can be removed (possibly using \link{invalid_city}) as well as single
(repeating) character strings ("XXXXXX").
}
\examples{
normal_city(
  city = c("Stowe, VT", "UNKNOWN CITY", "Burlington", "ST JOHNSBURY", "XXX"),
  abbs = c("ST" = "SAINT"),
  states = "VT",
  na = invalid_city,
  na_rep = TRUE
)
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
