% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect_geometry.R
\name{get_intersecting_geometries}
\alias{get_intersecting_geometries}
\title{Get identifiers for census regions interesecting a geometry}
\source{
Census data and boundary geographies are reproduced and distributed on
an "as is" basis with the permission of Statistics Canada (Statistics Canada
1996; 2001; 2006; 2011; 2016).
}
\usage{
get_intersecting_geometries(
  dataset,
  level,
  geometry,
  simplified = FALSE,
  use_cache = TRUE,
  quiet = FALSE,
  api_key = Sys.getenv("CM_API_KEY")
)
}
\arguments{
\item{dataset}{A CensusMapper dataset identifier.}

\item{level}{The census aggregation level to retrieve. One of \code{"Regions"}, \code{"PR"}, \code{"CMA"}, \code{"CD"}, \code{"CSD"}, \code{"CT"}, \code{"DA"}, \code{"EA"} (for 1996 census), or \code{"DB"} (for 2001-2016 censuses)..}

\item{geometry}{A valid \code{sf} or \code{sfc} class object. As long as the geometry is valid, any projection is accepted. Objects will be reprojected as server-side intersections use lat/lon projection.}

\item{simplified}{If \code{TRUE} will return a region list compatible with \link{get_census}, otherwise will return a character vector of matching region ids.}

\item{use_cache}{If set to \code{TRUE} (the default) data will be read from the local cache if available.}

\item{quiet}{When TRUE, suppress messages and warnings.}

\item{api_key}{An API key for the CensusMapper API. Defaults to \code{options()} and then the \code{CM_API_KEY} environment variable.}
}
\description{
This function returns a list of regions that intersect a given geometry input. This list of regions can be used
directly to query census when one is interested in census data for a particular geographic region that does
not coincide with defined census geometries. The returned value can be used as the \code{regions}
parameter in \link{get_census} to get corresponding census geographies and variables that cover the give geometry.
Input spatial objects can be any \code{sf} or \code{sfc} class objects such as \code{POINT}, \code{MULTIPOINT} or \code{POLYGON}.

This function comes with CensusMapper API limits
}
\examples{

\dontrun{
# Example using a POINT-class object from a pair of lat/lon coordinates
point_geo <- sf::st_sfc(sf::st_point(c(-123.25149, 49.27026)), crs=4326)
regions <- get_intersecting_geometries(dataset = 'CA16', level = 'CT', geometry = point_geo)
census_data <- get_census(dataset='CA16', regions=regions,
                          vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"),
                          level='CT')

# Example using a POLYGON-class object from a bounding box with four coordinates
poly_geo <- sf::st_as_sfc(sf::st_bbox(c(ymin = 49.25, ymax = 49.30,
                          xmin = -123.25, xmax = -123.30)), crs = 4326)
regions <- get_intersecting_geometries(dataset = 'CA16', level = 'CT', geometry = poly_geo)
census_data <- get_census(dataset='CA16', regions=regions,
                         vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"), level='CT')

}
}
