% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{categories_for_level}
\alias{categories_for_level}
\title{Use metadata to extract categories for column of specific level}
\usage{
categories_for_level(
  data,
  column_name,
  level = NA,
  strict = FALSE,
  remove_duplicates = TRUE
)
}
\arguments{
\item{data}{data table object as returned from \code{get_cansim()}}

\item{column_name}{the quoted name of the column to extract categories from}

\item{level}{the hierarchy level depth to which to extract categories, where 0 is top category}

\item{strict}{(default \code{FALSE}) when \code{TRUE} will only extract that specific hierarchy level}

\item{remove_duplicates}{(default \code{TRUE}) When set to \code{TRUE} higher level grouping categories already captured by lower level hierarchy data will be removed}
}
\value{
A vector of categories
}
\description{
For tables with data with hierarchical categories, metadata containing hierarchy level descriptions is used to extract categories at a specified level of hierarchy only.
}
\examples{
\dontrun{
data <- get_cansim("16-10-0117")
categories_for_level(data,"North American Industry Classification System (NAICS)",level=2)
}
}
