% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim}
\alias{get_cansim}
\title{Retrieves a Statistics Canada data table using CANSIM code or NDM table number}
\usage{
get_cansim(
  cansimTableNumber,
  language = "english",
  refresh = FALSE,
  timeout = 200
)
}
\arguments{
\item{cansimTableNumber}{the table number to load, accepts old CANSIM or new NDM table numbers}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (default is set to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}
}
\value{
tibble format data table output
}
\description{
Retrieves a data table as a tidy dataframe using either an old-style CANSIM code or a new-format NDM table number. This function will automatically convert old-style CANSIM codes into their new equivalents. Retrieved table data is cached for the duration of the current R session only by default.
}
\examples{
# Retrieve a table with an NDM code
get_cansim("34-10-0013")
# Retrieve a table with an old-style CANSIM code
get_cansim("026-0018")

}
