% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim_table_info}
\alias{get_cansim_table_info}
\title{Retrieve Statistics Canada data table information}
\usage{
get_cansim_table_info(
  cansimTableNumber,
  language = "english",
  refresh = FALSE,
  timeout = 200
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (default set to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}
}
\value{
A tibble with the table overview information
}
\description{
Returns table information given an NDM table catalogue number in English or French. Retrieved table information data is cached for the duration of the R session only.
}
\examples{
\dontrun{
get_cansim_table_info("34-10-0013")
}
}
