#' Owned animal data from a systematic sample
#'
#' Owned animal hypothetical data from a two-stage cluster sample.
#'
#' @format A data frame with 935 observations and 15 variables:
#' #' \describe{
#'   \item{hh_id}{Household ID.}
#'   \item{name}{Animal's name.}
#'   \item{species}{Animal's species.}
#'   \item{sex}{Animal's sex.}
#'   \item{age}{Animal's age. An age equal to 0 means that the  has less than 1 year.}
#'   \item{sterilized}{Animal's reproductive status.}
#'   \item{sterilized_last_year}{For sterilized animals, indicates if the animal was sterilized in the previous 12 months.}
#'   \item{free_roaming}{Indicates if the animal has access to the street without supervision.}
#'   \item{acquisition}{Way of acquisition}
#'   \item{acquired_last_year}{Indicates if the animal was acquired in the previous 12 months.}
#'   \item{acquired_sterilized}{Indicates if the animal was sterilized when acquired.}
#'   \item{acquisition_city}{City of acquisition.}
#'   \item{acquisition_state}{State of acquisition.}
#'   \item{turnover_last_year}{Indicates if the animal was acquired in the 12 months following the lost of another .}
#'   \item{litter_size_last_year}{Litter size if the bitch/quenn had the litter in the previous 12 months.}
#' }
"sys_sample_animals"