% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DesignSurvey.R
\name{DesignSurvey}
\alias{DesignSurvey}
\title{Survey design}
\usage{
DesignSurvey(sample = NULL, psu.ssu = NULL, psu.col = NULL,
  ssu.col = NULL, cal.col = NULL, N = NULL, strata = NULL,
  cal.N = NULL, ...)
}
\arguments{
\item{sample}{\code{\link{data.frame}} with sample observations. for two-stage cluster designs, one of the columns must contain unique identifiers for PSU and another column must contain unique identifiers for Secondary Sampling Units (SSU).}

\item{psu.ssu}{\code{\link{data.frame}} with all Primary Sampling Units (PSU). First column contains PSU unique identifiers. Second column contains \code{\link{numeric}} PSU sizes. It is used only for two-stage cluster designs.}

\item{psu.col}{the column of \code{sample} containing the psu identifiers (for two-stage cluster designs). It is used only for two-stage cluster designs.}

\item{ssu.col}{the column of \code{sample} containing the ssu identifiers (for two-stage cluster designs). It is used only for two-stage cluster designs.}

\item{cal.col}{the column of \code{sample} with the variable to calibrate estimates. It must be used together with \code{cal.N}.}

\item{N}{for simple designs, a \code{\link{numeric}} value representing the total of sampling units in the population. for a stratified design, it is a column of \code{sample} indicating, for each observation, the total of sampling units in its respective strata. \code{N} is ignored in two-stage cluster designs.}

\item{strata}{for stratified designs, a column of \code{sample} indicating the strata memebership of each observation.}

\item{cal.N}{population total for the variable to calibrate the estimates. It must be used togheter with \code{cal.col}.}

\item{...}{further arguments passed to \code{\link{svydesign}} function.}
}
\value{
An object of class survey.design.
}
\description{
A wraper for \code{\link{svydesign}} function from the survey package, to define one of the following survey designs: two-stage cluster, simple (systematic) or stratified. In the first case, weights are calculated considering a sample with probability proportional to size and with replacement for the first stage and a simple random sampling for the second stage. Finite population correction is specified as the population size for each level of sampling.
}
\details{
For two-stage cluster designs, a PSU appearing in both \code{psu.ssu} and in \code{sample} must have the same identifier. SSU identifiers must be unique but can appear more than once if there is more than one observation per SSU. \code{sample} argument must have just the varibles to be estimated plus the variables required to define the design (two-stage cluster or stratified). \code{cal.col} and \code{cal.N} are needed only if estimates will be calibrated. The calibration is based on a population total.
}
\examples{
data("cluster_sample")
data("psu_ssu")

## Calibrated two-stage cluster design
design <- DesignSurvey(na.omit(cluster_sample),
                       psu.ssu = psu_ssu,
                       psu.col = "census_tract_id",
                       ssu.col = "interview_id",
                       cal.col = "number_of_persons",
                       cal.N = 129445)

## Simple design
# If data in cluster_sample were from a simple design:
design <- DesignSurvey(na.omit(cluster_sample), 
                       N = sum(psu_ssu$hh),
                       cal.N = 129445)

## Stratified design
# Simulate strata and assume that the data in cluster_design came
# from a stratified design
cluster_sample$strat <- sample(c("urban", "rural"),
                               nrow(cluster_sample),
                               prob = c(.95, .05),
                               replace = TRUE)
cluster_sample$strat_size <- round(sum(psu_ssu$hh) * .95)
cluster_sample$strat_size[cluster_sample$strat == "rural"] <-
  round(sum(psu_ssu$hh) * .05)
design <- DesignSurvey(cluster_sample,
                       N = "strat_size",
                       strata = "strat",
                       cal.N = 129445)

}
\references{
Lumley, T. (2011). Complex surveys: A guide to analysis using R (Vol. 565). Wiley.

Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
