% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plastic_emissions.R
\name{plastic_emissions}
\alias{plastic_emissions}
\title{Calculate Plastic Emissions}
\usage{
plastic_emissions(
  average = 0,
  average_film = 0,
  average_rigid = 0,
  HDPE = 0,
  LDPE = 0,
  LLDPE = 0,
  PET = 0,
  PP = 0,
  PS = 0,
  PVC = 0,
  average_WD = 0,
  average_film_WD = 0,
  average_rigid_WD = 0,
  HDPE_WD = 0,
  LDPE_WD = 0,
  LLDPE_WD = 0,
  PET_WD = 0,
  PP_WD = 0,
  PS_WD = 0,
  PVC_WD = 0,
  waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  units = c("kg", "tonnes")
)
}
\arguments{
\item{average}{Numeric value indicating the weight of average plastic. Default is \code{0}.}

\item{average_film}{Numeric value indicating the weight of average film plastic. Default is \code{0}.}

\item{average_rigid}{Numeric value indicating the weight of average rigid plastic. Default is \code{0}.}

\item{HDPE}{Numeric value indicating the weight of HDPE plastic. Default is \code{0}.}

\item{LDPE}{Numeric value indicating the weight of LDPE plastic. Default is \code{0}.}

\item{LLDPE}{Numeric value indicating the weight of LLDPE plastic. Default is \code{0}.}

\item{PET}{Numeric value indicating the weight of PET plastic. Default is \code{0}.}

\item{PP}{Numeric value indicating the weight of PP plastic. Default is \code{0}.}

\item{PS}{Numeric value indicating the weight of PS plastic. Default is \code{0}.}

\item{PVC}{Numeric value indicating the weight of PVC plastic. Default is \code{0}.}

\item{average_WD}{Numeric value indicating the weight of average plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_film_WD}{Numeric value indicating the weight of average film plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_rigid_WD}{Numeric value indicating the weight of average rigid plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{HDPE_WD}{Numeric value indicating the weight of HDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LDPE_WD}{Numeric value indicating the weight of LDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LLDPE_WD}{Numeric value indicating the weight of LLDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PET_WD}{Numeric value indicating the weight of PET plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PP_WD}{Numeric value indicating the weight of PP plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PS_WD}{Numeric value indicating the weight of PS plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PVC_WD}{Numeric value indicating the weight of PVC plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{waste_disposal}{Character vector specifying the waste disposal method to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Closed-loop"}.
\code{"Open-loop"} is the process of recycling material into other products.
\code{"Closed-loop"} is the process of recycling material back into the same product.
\code{"Combustion"} energy is recovered from the waste through incineration and subsequent generation of electricity.
\code{"Landfill"} the product goes to landfill after use.}

\item{units}{Character vector specifying the units of the emissions output. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}
}
\value{
The calculated plastic emissions as a numeric value in tonnes.
}
\description{
This function calculates the emissions produced from different plastic sources based on the specified inputs. It considers emissions from primary material production and waste disposal of plastic materials.
}
\examples{
# Calculate plastic emissions using default values
plastic_emissions()

# Calculate plastic emissions with specific quantities and waste disposal
# method
plastic_emissions(average = 100, HDPE = 50, PET = 25,
                  waste_disposal = "Combustion", units = "tonnes")
}
