\name{carcass-package}
\alias{carcass-package}
\alias{carcass}
\docType{package}
\title{
Estimation of the Number of Fatalities from Carcass Searches
}
\description{
The number of bird or bat fatalities from collisions with buildings, towers or 
wind energy turbines can be estimated based on carcass searches and experimentally 
assessed carcass persistence times and searcher efficiency. This package provides 
diverse functions for estimating the probability that a bird or bat that died is 
found by a searcher. It further provides a function to obtain a posterior distribution 
of the number of fatalities based on the number of carcasses found and the estimated detection probability.
see worked example in Korner-Nievergelt et al 2011

}
\details{
\tabular{ll}{
Package: \tab carcass\cr
Type: \tab Package\cr
Version: \tab 1.3\cr
Date: \tab 2014-10-01\cr
License: \tab GUI2\cr
LazyLoad: \tab yes\cr
}
}
\author{
Fraenzi Korner-Nievergelt, Ivo Niermann, Oliver Behr, Matthew A. Etterson, Robert Brinkmann, Pius Korner, Barbara Hellriegel, Tobias Roth, Manuela M. P. Huso, Dan Dalthorp

Maintainer: Fraenzi Korner-Nievergelt <fraenzi.korner@oikostat.ch>

The authors thank Helga Garcia and Joana Bernardino for reporting bugs.
}
\references{
Erickson WP, Jeffrey J, Kronner K, Bay K (2004) Stateline Wind Project Wildlife. Monitoring Final Report, July 2001 - December 2003. - Technical report peer-reviewed by and submitted to FPL Energy, the Oregon Energy Facility Siting Council, and the Stateline Technical Advisory Committee, Oregon, USA, 105 pp\cr

Etterson, M.A. (2013) Hidden Markov models for estimating animal mortality from antropogenic hazards. Ecological Applications, 23, 1915-1925.

Huso M (2010) An estimator of wildlife fatality from observed carcasses. Environmetrics 22: 318-329\cr

Korner-Nievergelt F, Korner-Nievergelt P, Behr O, Niermann I, Brinkmann R, Hellriegel B (2011) A new method to determine bird and bat fatality at wind energy turbines from carcass searches. Wildlife Biology 17: 350-363
}
\keyword{ package }