% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_hierarchical.R
\name{ard_hierarchical}
\alias{ard_hierarchical}
\alias{ard_hierarchical_count}
\title{Hierarchical ARD Statistics}
\usage{
ard_hierarchical(
  data,
  variables,
  by = dplyr::group_vars(data),
  statistic = everything() ~ categorical_summary_fns(),
  denominator = NULL,
  fmt_fn = NULL,
  stat_label = everything() ~ default_stat_labels()
)

ard_hierarchical_count(
  data,
  variables,
  by = dplyr::group_vars(data),
  fmt_fn = NULL,
  stat_label = everything() ~ default_stat_labels()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
variables to perform the nested/hierarchical tabulations within.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
variables to perform tabulations by. All combinations of the variables
specified here appear in results. Default is \code{dplyr::group_vars(data)}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \code{list(mpg = categorical_summary_fns())}.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
Specify this \emph{optional} argument to change the denominator,
e.g. the \code{"N"} statistic. Default is \code{NULL}. See below for details.}

\item{fmt_fn}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character))}.}

\item{stat_label}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(n = "n", p = "pct")} or
\code{everything() ~ list(n ~ "n", p ~ "pct")}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Performs hierarchical or nested tabulations, e.g. tabulates AE terms
nested within AE system organ class.
\itemize{
\item \code{ard_hierarchical()} includes summaries for the last variable listed
in the \code{variables} argument, nested within the other variables included.
\item \code{ard_hierarchical_count()} includes summaries for \emph{all} variables
listed in the \code{variables} argument each summary nested within the preceding
variables, e.g. \code{variables=c(AESOC, AETERM)} summarizes \code{AETERM} nested
in \code{AESOC}, and also summarizes the counts of \code{AESOC}.
}
}
\examples{
ard_hierarchical(
  data = ADAE,
  variables = c(AESOC, AETERM),
  by = c(TRTA, AESEV),
  denominator = ADSL |> dplyr::rename(TRTA = ARM)
)

ard_hierarchical_count(
  data = ADAE,
  variables = c(AESOC, AETERM),
  by = TRTA
)
}
