% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_regression_basic.R
\name{ard_regression_basic}
\alias{ard_regression_basic}
\title{Basic Regression ARD}
\usage{
ard_regression_basic(
  x,
  tidy_fun = broom.helpers::tidy_with_broom_or_parameters,
  stats_to_remove = c("term", "var_type", "var_label", "var_class", "label",
    "contrasts_type", "contrasts", "var_nlevels"),
  ...
)
}
\arguments{
\item{x}{regression model object}

\item{tidy_fun}{(\code{function})\cr
a tidier. Default is \code{\link[broom.helpers:tidy_with_broom_or_parameters]{broom.helpers::tidy_with_broom_or_parameters}}}

\item{stats_to_remove}{(\code{character})\cr
character vector of statistic names to remove. Default is
\code{c("term", "var_type", "var_label", "var_class", "label", "contrasts_type", "contrasts", "var_nlevels")}.}

\item{...}{Arguments passed to \code{\link[broom.helpers:tidy_plus_plus]{broom.helpers::tidy_plus_plus()}}}
}
\value{
data frame
}
\description{
A function that takes a regression model and provides basic statistics in an
ARD structure.
The default output is simpler than \code{\link[=ard_regression]{ard_regression()}}.
The function primarily matches regression terms to underlying variable names
and levels.
The default arguments used are

\if{html}{\out{<div class="sourceCode r">}}\preformatted{broom.helpers::tidy_plus_plus(
  add_reference_rows = FALSE,
  add_estimate_to_reference_rows = FALSE,
  add_n = FALSE,
  intercept = FALSE
)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom.helpers", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lm(AGE ~ ARM, data = cards::ADSL) |>
  ard_regression_basic()
\dontshow{\}) # examplesIf}
}
