% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survfit.R
\name{.process_survfit_time}
\alias{.process_survfit_time}
\title{Process Survival Fit For Time Estimates}
\usage{
.process_survfit_time(x, times, type, start.time = NULL)
}
\arguments{
\item{x}{(\code{\link[survival:survfit]{survival::survfit()}})\cr
a \code{\link[survival:survfit]{survival::survfit()}} object. See below for details.}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{type}{(\code{string} or \code{NULL})\cr
type of statistic to report. Available for Kaplan-Meier time estimates only, otherwise \code{type}
is ignored. Default is \code{NULL}.
Must be one of the following:\tabular{ll}{
   type \tab transformation \cr
   \code{"survival"} \tab \code{x} \cr
   \code{"risk"} \tab \code{1 - x} \cr
   \code{"cumhaz"} \tab \code{-log(x)} \cr
}}

\item{start.time}{(\code{numeric})\cr
default starting time. See \code{\link[survival:survfit0]{survival::survfit0()}} for more details.}
}
\value{
a \code{tibble}
}
\description{
Process Survival Fit For Time Estimates
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survival", "broom"), reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
survival::survfit(survival::Surv(AVAL, CNSR) ~ TRTA, cards::ADTTE) |>
  cardx:::.process_survfit_time(times = c(60, 180), type = "risk")
\dontshow{\}) # examplesIf}
}
\keyword{internal}
