% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_regression.R
\name{ard_regression}
\alias{ard_regression}
\alias{ard_regression.default}
\title{Regression ARD}
\usage{
ard_regression(x, ...)

\method{ard_regression}{default}(x, tidy_fun = broom.helpers::tidy_with_broom_or_parameters, ...)
}
\arguments{
\item{x}{regression model object}

\item{...}{Arguments passed to \code{\link[broom.helpers:tidy_plus_plus]{broom.helpers::tidy_plus_plus()}}}

\item{tidy_fun}{(\code{function})\cr
a tidier. Default is \code{\link[broom.helpers:tidy_with_broom_or_parameters]{broom.helpers::tidy_with_broom_or_parameters}}}
}
\value{
data frame
}
\description{
Function takes a regression model object and converts it to a ARD
structure using the \code{broom.helpers} package.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom.helpers", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lm(AGE ~ ARM, data = cards::ADSL) |>
  ard_regression(add_estimate_to_reference_rows = TRUE)
\dontshow{\}) # examplesIf}
}
