% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_t_test.R
\name{ard_stats_t_test}
\alias{ard_stats_t_test}
\alias{ard_stats_paired_t_test}
\title{ARD t-test}
\usage{
ard_stats_t_test(data, variables, by = NULL, conf.level = 0.95, ...)

ard_stats_paired_t_test(data, by, variables, id, conf.level = 0.95, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent t-tests will be computed for
each variable.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
optional column name to compare by.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{...}{arguments passed to \code{t.test()}}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name of the subject or participant ID}
}
\value{
ARD data frame
}
\description{
Analysis results data for paired and non-paired t-tests.
}
\details{
For the \code{ard_stats_t_test()} function, the data is expected to be one row per subject.
The data is passed as \code{t.test(data[[variable]] ~ data[[by]], paired = FALSE, ...)}.

For the \code{ard_stats_paired_t_test()} function, the data is expected to be one row
per subject per by level. Before the t-test is calculated, the data are
reshaped to a wide format to be one row per subject.
The data are then passed as
\verb{t.test(x = data_wide[[<by level 1>]], y = data_wide[[<by level 2>]], paired = TRUE, ...)}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cards::ADSL |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  ard_stats_t_test(by = ARM, variables = c(AGE, BMIBL))

# constructing a paired data set,
# where patients receive both treatments
cards::ADSL[c("ARM", "AGE")] |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  dplyr::mutate(.by = ARM, USUBJID = dplyr::row_number()) |>
  dplyr::arrange(USUBJID, ARM) |>
  ard_stats_paired_t_test(by = ARM, variables = AGE, id = USUBJID)
\dontshow{\}) # examplesIf}
}
