% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_poisson_test.R
\name{.format_poissontest_results}
\alias{.format_poissontest_results}
\title{Convert Poisson test to ARD}
\usage{
.format_poissontest_results(by = NULL, variables, lst_tidy, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variables}{(\code{character})\cr names of the event and time variables}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{...}{passed to \code{\link[=poisson.test]{poisson.test()}}}
}
\value{
ARD data frame
}
\description{
Convert Poisson test to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cardx:::.format_poissontest_results(
  by = "ARM",
  variables = c("CNSR", "AVAL"),
  lst_tidy =
    cards::eval_capture_conditions(
      stats::poisson.test(sum(cards::ADTTE[["CNSR"]]), sum(cards::ADTTE[["AVAL"]])) |>
        broom::tidy()
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
