% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_evaluation.R
\name{aggregate_raw_sim_rslt}
\alias{aggregate_raw_sim_rslt}
\title{Comprehensively Aggregate Raw Simulation Results}
\usage{
aggregate_raw_sim_rslt(sim_areas_raw, concept_def)
}
\arguments{
\item{sim_areas_raw}{Raw simulation results as obtained from
\code{\link{sim_area_single_concept_with_risk}}}

\item{concept_def}{The concept definition (a \code{c4c_concept} object) used
for the simulation which generated \code{sim_areas_raw}}
}
\value{
A list of three matrices with named columns. Each row of these
matrices represents a point in simulation time, but only integer times. The
time distance from one row to the next one is one time unit, typically one
year. The first column of the matrices is time, the other columns represent
the stand development phases as defined in \code{concept_def}. The three
list elements (matrices) are:\cr
\itemize{
\item{\emph{areas}: Contains the simulated areas of each stand development
phase in the area units defined in \code{concept_def}, usually ha.}
\item{\emph{area_inflows_regular}: The area inflows into each stand
development phase as caused by regular development, not by damage
events. An entry at a given point in time represents the inflow between
(and up to) this and the previous point in time. Therefore, the entries
at time 0 are NA.}
\item{\emph{area_outflows_events}: Area outflows of each stand development
phase as caused by damage events. An entry at a given point in time
represents the inflow between (and up to) this and the previous point
in time. Therefore, the entries at time 0 are NA.}
}
}
\description{
Aggregate and prepare raw simulation output as obtained from
\code{\link{sim_area_single_concept_with_risk}} in a way that makes them
readable and appropriate for further processing.
}
\examples{
  # Make a simulation
  state_vars <- setup_statevars(
    pine_thinning_from_above_1, c(1000, 0, 0, 0, 0, 0)
  )
  time_span  <- 50
  parms      <- setup_parms(pine_thinning_from_above_1)
  parms$risk_mat <- setup_risk_events(
    time_span, avg_event_strength = 1, parms$risk
  )

  # Simulate
  sim_rslt_raw <- sim_area_single_concept_with_risk(
    state_vars,
    parms       = parms,
    event_times = c(0:time_span),
    time_span   = time_span
  )

  aggregate_raw_sim_rslt(sim_rslt_raw, pine_thinning_from_above_1)


}
